/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.demos.view;

import java.awt.Component;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.common.view.InstallLocationPane;
import oracle.install.ivw.demos.bean.DemosInstallSettings;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.OFAWrapper;

@ViewDef(id="InstallLocationUI")
public class InstallLocationGUI
implements View {
    private InstallLocationPane installLocationPane = new InstallLocationPane();

    private void initialize(FlowContext flowContext) {
        DemosInstallSettings demosInstallSettings = (DemosInstallSettings)((Object)flowContext.getBean(DemosInstallSettings.class));
        String oraBase = new String();
        String oraHome = new String();
        oraHome = demosInstallSettings.getOracleHome();
        oraBase = demosInstallSettings.getOracleBase();
        if (GenericValidation.isEmpty((String)oraBase)) {
            oraBase = OFAWrapper.getInstance().getDefaultOracleBaseLocation();
        }
        if (GenericValidation.isEmpty((String)oraHome) && GenericValidation.isEmpty((String)(oraHome = OFAWrapper.getInstance().getOracleHomeFromEnv()))) {
            this.installLocationPane.setComputeOracleHomeLoc(true);
            oraHome = OFAWrapper.getInstance().getDBHomeLoc(oraBase);
            this.installLocationPane.setDefOracleHomeLocation(oraHome);
        }
        this.installLocationPane.setOracleHomeLocation(oraHome);
        if (!GenericValidation.isEmpty((String)OFAWrapper.getInstance().getBaseForLocation(oraHome))) {
            oraBase = OFAWrapper.getInstance().getBaseForLocation(oraHome);
            this.installLocationPane.dissableOracleBase();
        }
        this.installLocationPane.setOracleBase(oraBase);
        this.installLocationPane.setOracleBaseActiveHelpId("InstallLocationUI.cbxOracleBases");
        this.installLocationPane.setOracleHomeActiveHelpId("InstallLocationUI.cbxSoftwareLoc");
    }

    public Component getView() {
        return this.installLocationPane;
    }

    public void localize(FlowContext flowContext) {
        Resource resource = Application.getInstance().getResource("oracle.install.ivw.demos.resource.DemosDialogLabelResID");
        String oraBaseDesc = resource.getString("INSTALL_DEMOS_LOCATION_DLG_LABEL_ORABASE_DESC", "Specify an Oracle base path to place all Oracle software and configuration-related files.  This location is the Oracle base directory.", new Object[0]);
        String oraHomeDesc = resource.getString("INSTALL_DEMOS_LOCATION_DLG_LABEL_ORAHOME_DESC", "Enter or select the full path where you want to install the Oracle Database examples.  This location should refer to an existing Oracle Database installation.", new Object[0]);
        this.installLocationPane.setOracleBaseDesc(oraBaseDesc);
        this.installLocationPane.setOracleHomeDesc(oraHomeDesc);
        this.installLocationPane.localize();
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        switch (eventType) {
            case INIT: {
                this.initialize(flowContext);
            }
        }
    }

    public void processInput(FlowContext flowContext) {
        DemosInstallSettings installSettings = (DemosInstallSettings)((Object)flowContext.getBean(DemosInstallSettings.class));
        CentralInventorySettings cenInv = (CentralInventorySettings)flowContext.getBean(CentralInventorySettings.class);
        String oracleBase = this.installLocationPane.getOracleBase();
        String oracleHomeLocation = this.installLocationPane.getOracleHomeLocation();
        installSettings.setOracleBase(oracleBase);
        cenInv.setInventoryLocation(InventoryInfo.computeInventoryLocation((String)oracleBase));
        installSettings.setOracleHome(oracleHomeLocation);
    }
}

